//
//  TSDetailsViewController.h
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/15/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <MapKit/MapKit.h>
#import <CoreLocation/CoreLocation.h>
#import <MobileCoreServices/MobileCoreServices.h>

#import "RTBSign.h"
#import "RTBGame.h"
#import "UIColor+RTBColors.h"
#import "UIImage+Thumbnail.h"
#import "RTBFileHandler.h"

#define kConfirmationAlertView 1

@class TSDetailsViewController;

@protocol TSDetailsViewControllerDelegate <NSObject>
- (void) passTSToGameBoardViewController:(TSDetailsViewController *)controller didFinishEditingTS:(RTBSign *)selectedItem inGame: (RTBGame *)game;
@end


@interface TSDetailsViewController : UIViewController <UIActionSheetDelegate, UIImagePickerControllerDelegate, UINavigationControllerDelegate, MKMapViewDelegate, CLLocationManagerDelegate>

@property (strong, nonatomic) RTBSign *detailedTS;
@property (strong, nonatomic) RTBGame *currentGame;
@property BOOL prebingo;

- (IBAction)backButton:(id)sender;
@property (weak, nonatomic) IBOutlet UILabel *tsInfoLabel;
@property (weak, nonatomic) IBOutlet UIImageView *tsDefaultImage;
@property (weak, nonatomic) IBOutlet UIImageView *tsUserImage;
@property (weak, nonatomic) IBOutlet UIImageView *tsConfirmationImage;
@property (weak, nonatomic) IBOutlet MKMapView *mapView;
@property (weak, nonatomic) IBOutlet UILabel *signTitle;

@property (nonatomic, strong) UIImagePickerController *imagePicker;

@property (weak, nonatomic) id<TSDetailsViewControllerDelegate> delegate;

- (IBAction)didTapPicture:(UITapGestureRecognizer *)sender;



//user defined methods
- (void)useCamera;
- (void)useCameraRoll;
//- (UIImage*)loadImageWithName: (NSString *) fileName;
//- (BOOL)saveImage: (UIImage*)image withFileName: (NSString *)fileName;
//- (BOOL) checkOrCreateFolder: (NSString *)path;



@end
